/*:
 * @target MV
 * @plugindesc メッセージ内でSEを再生するプラグイン
 * @author hisa_mon
 *
 * @help
 * メッセージ内に以下の制御文字を入力すると
 * 指定したSEが再生されます。
 *
 * \S[SE名, 音量, ピッチ, 位相]
 *
 * 【例】
 * \S[example, 90, 100, 0]  → "example"を音量90、ピッチ100、位相0で再生
 *
 * 利用規約：
 *  作者に無断での改変、再配布が可能です。
 *  利用形態（商用、18禁利用）も問いません。
 *  著作権表記も不要です。
 *  ご自由にお使いください。
 *
 */

(() => {
    'use strict';

    const _SE_Play_process = Window_Message.prototype.processEscapeCharacter;
    
    Window_Message.prototype.SE_Play = function(code, textState) {
        if (code === 'S') {
            const text = textState.text.slice(textState.index);
            const match = text.match(/^\[(.+?)\]/);

            if (match) {
                const params = match[1];

                const splitParams = params.split(/\s*,\s*/);
                if (splitParams.length !== 4) {
                    return;
                }
                const seName = splitParams[0].trim();
                const volume = parseInt(splitParams[1]);
                const pitch = parseInt(splitParams[2]);
                const pan = parseInt(splitParams[3]);

                AudioManager.playSe({ name: seName, volume: volume, pitch: pitch, pan: pan });

                textState.index += match[0].length;
            } else {
            }
        } else {
            _SE_Play_process.apply(this, arguments);
        }
    };
    Window_Message.prototype.processEscapeCharacter = Window_Message.prototype.SE_Play;
})();
